 ; Ŀ
 ;   Blex - explode all blocks, but not xrefs or locked layer stuff.       
 ;   Copyright 2004, 2009 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Blex - explode a block if possible.                                   
 ;   Arguments: Enam, an entity name.                                      
 ;              Lixt, a list of xref names.                                
 ;   Calls nothing.                                                        
 ;   Returns nothing.                                                      
 ;   Rides a black horse called Xavier.                                    
 ; 
 (DEFUN BLEX (enam lixt / entt blnam alnam lofo)
 ; Ŀ
 ;   Explode the block.                                                    
 ; 
  (setq entt (entget enam))
  (setq blnam (cdr (assoc 2 entt)))
  (prompt (strcat "\n" blnam))          ; reassure the user
  (setq alnam (cdr (assoc 8 entt)))
  (setq lofo (layp alnam))
  (cond ((member "locked" lofo)
         (prompt (strcat "\nBlock " blnam 
                         " is on locked layer " alnam ".")))
        ((member "frozen" lofo)
         (prompt (strcat "\nBlock " blnam 
                         " is on frozen layer " alnam ".")))
        ((member blnam lixt)
         (prompt (strcat "\nBlock " blnam 
                         " is an xref.")))
        (t
         (command ".explode" enam)))
 (princ))
 ; Ŀ
 ;   Blex end.                                                             
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Xlp - returns a list of all loaded xref blocks in the drawing.        
 ; Ĵ
 ;   70  Block-type flags (bit-coded values, may be combined):             
 ; Ĵ
 ;   0     Indicates none of the following flags apply.                   
 ; Ĵ
 ;   1     This is an anonymous block generated by hatching, associative  
 ;         dimensioning, other internal operations, or an application.    
 ; Ĵ
 ;   2     This block has non-constant attribute definitions (this bit    
 ;         is not set if the block has any attribute definitions that     
 ;         are constant, or has no attribute definitions at all).         
 ; Ĵ
 ;   4     This block is an external reference (xref).                    
 ; Ĵ
 ;   8     This block is an xref overlay.                                 
 ;         (These apparently always have the 4 bit set too.)              
 ; Ĵ
 ;   16    This block is externally dependent.                            
 ;         (i.e. a subentity of an xref.  These seem to bind along        
 ;         with the xref.)                                                
 ; Ĵ
 ;   32    This is a resolved external reference, or dependent of an      
 ;         external reference (ignored on input).                         
 ;         (In other words, a loaded xref.)                               
 ; Ĵ
 ;   64    This definition is a referenced external reference (ignored    
 ;         on input).  (This doesn't seem to ever be set.)                
 ; 
 (DEFUN XLP (/ rew bldat blnam dat xp isxrf isrefd blist)
  (setq rew T)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 bldat)))
         (setq dat (tblsearch "block" blnam))
         (setq xp (cdr (assoc 70 dat)))
         (setq isxrf (logand xp 4))
         (setq isrefd (logand xp 32))
         (if (and (= isxrf 4) (= isrefd 32))
             (setq blist (cons blnam blist))))
 blist)
 ; Ŀ
 ;   Xlp end.                                                              
 ; 

 ; Ŀ
 ;   Blex.                                                                 
 ; 
 (DEFUN C:BLEX (/ aa bb lixt num ss enam osm)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "osmode" osm)
   (command "undo" "end")
   (if shk (write-line shk)))
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aa (entlast))
  (while (setq bb (entnext aa))
         (setq aa bb))
 ; Ŀ
 ;   Get a list of all loaded xrefs in the drawing.                        
 ; 
  (setq lixt (xlp))
 ; Ŀ
 ;   Explode all blocks.                                                   
 ; 
  (setq num 0)
  (setq ss (ssget "x" (list (cons 0 "insert"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (if (entget enam)    ; some entities return nil on entget ... ?
             (blex enam lixt))
         (setq num (1+ num)))
 ; Ŀ
 ;   Now explode all new entities (those after aa) until come to the       
 ;   end of the list.  Since new entities are added to the end, once       
 ;   there are no further entities everything has been exploded which      
 ;   is likely to be.                                                      
 ; 
  (while (setq bb (entnext aa))
         (setq aa bb)
         (if (= (cdr (assoc 0 (entget aa))) "INSERT")
             (blex aa lixt)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))